# normal_quantile_plot2.R
# Fitting the normal to development data

# Load necessary libraries
library(ggplot2)
library(psych)

# Read in data set
devel_time <- read.table(header=T,colClasses=c("numeric","numeric"),text="
time_pp time_adult
34 65
31 48
29 NA
30 55
32 62
32 47
37 44
34 53
31 NA
37 53
32 NA
31 42
29 NA
35 NA
39 NA
34 43
32 NA
34 NA
34 113
32 47
32 100
41 NA
32 49
29 NA
32 53
39 NA
39 84
35 NA
32 NA
35 74
36 43
31 50
34 NA
35 44
35 116
34 NA
34 NA
37 58
36 101
32 67
34 68
34 61
28 66
31 84
30 68
28 106
28 42
31 58
31 42
28 68
32 55
32 NA
30 101
30 99
39 43
30 80
28 52
27 50
28 110
28 42
30 NA
28 66
28 147
27 NA
37 135
30 119
29 113
30 103
30 95
27 87
29 89
33 NA
27 76
27 NA
30 NA
30 49
30 81
29 85
27 NA
31 104
27 73
27 110
27 NA
31 99
31 55
31 59
27 NA
30 93
27 NA
28 84
28 93
29 NA
29 108
31 103
33 NA
29 92
")

# Print the data
cat("Descriptive statistics for elytra data\n")
cat("devel_time:\n")
print(devel_time)

# Graphics using ggplot2
ggplot(devel_time,aes(time_pp))+
geom_histogram(binwidth=2.5)
ggplot(devel_time,aes(time_adult))+
geom_histogram(binwidth=10)

# Descriptive statistics
describe(devel_time$time_pp)
describe(devel_time$time_adult)

# Normal quantile plots
qqnorm(devel_time$time_pp,main="time_pp")
qqnorm(devel_time$time_adult,main="time_adult")
